<?php
  // This test simulates situation when a high-priority action is put behind a low-priority one.

class Utfp2highpriority_Root extends UWikiBaseAction {
  function Priority($format, $params) { return (int) UWikiMaxPriority * 0.7; }

  function Execute($format, $params) {
    global $tfp2ParseCounts;
    ++$tfp2ParseCounts['high'];

    TestThat($tfp2ParseCounts['med'] === 1);
    TestThat($tfp2ParseCounts['low'] === 1);
  }
}

class Utfp2medpriority_Root extends UWikiBaseAction {
  function Execute($format, $params) {
    global $tfp2ParseCounts;
    ++$tfp2ParseCounts['med'];

    TestThat($tfp2ParseCounts['high'] === 0);
    TestThat($tfp2ParseCounts['low'] === 0);
  }
}

class Utfp2lowpriority_Root extends UWikiBaseAction {
  function Priority($format, $params) { return (int) UWikiMaxPriority * 0.3; }

  function Execute($format, $params) {
    global $tfp2ParseCounts;
    ++$tfp2ParseCounts['low'];

    TestThat($tfp2ParseCounts['high'] === 0);
    TestThat($tfp2ParseCounts['med'] === 1);
  }
}


  $src = '
%%(tfp2Medpriority)
z
%%
%%(tfp2Lowpriority; tfp2Highpriority)
z
%%
';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

  global $tfp2ParseCounts;

    $tfp2ParseCounts = array('high' => 0, 'med' => 0, 'low' => 0);
      $doc->Parse();
    TestThat( $tfp2ParseCounts === array('high' => 1, 'med' => 1, 'low' => 1) );

    $tfp2ParseCounts = array('high' => 0, 'med' => 0, 'low' => 0);
      $doc->ToHTML();
    TestThat( $tfp2ParseCounts === array('high' => 0, 'med' => 0, 'low' => 0) );
